/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh mbox , // mesh box
     mball; // mesh ball
/******************************************************************************/
void InitPre()
{
   App.name="Rendering Shadows";
   App.flag=APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=3;

   Material *material=Materials("../data/mtrl/brick/0.mtrl");

   mbox .create(1).B(0).create( Box(3),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create mesh box, reverse it because it's meant to be viewed from inside
   mball.create(1).B(0).create(Ball(1),VTX_TX0|VTX_NRM|VTX_TNG)          ; // create mesh ball

   // set mesh materials, rendering versions and bounding boxes
   mbox .setMaterial(material).setRender().setBox();
   mball.setMaterial(material).setRender().setBox();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(1.5,10,CAMH_ZOOM|CAMH_ROT);
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox .draw(MatrixIdentity);
         mball.draw(MatrixIdentity);
      break;

      case RM_LIGHT: 
         LightPoint(10,Vec(Cos(Tm.time()),Sin(Tm.time()),-1.5)).add();
      break;
      
      // since we want to render shadows we have to process additional rendering mode 'RM_SHD_MAP' (render shadows through shadow maps)
      // here we will render all meshes which cast shadows
      case RM_SHD_MAP:
         mball.draw(MatrixIdentity);
      break;
   }
}
void Draw()
{
   Renderer(Render);

   D.text(0,0.9,S+"Fps "+Tm.fps); // show number of fps
}
/******************************************************************************/
